/////////////////////////////////////////////////////////////////////////////
//
//	File: TestThread.h
//
//	$Header: /Projects/QzTest/TestThread.h  1  2009/9/9 9:48:02a  Lee $
//
//
//	This is a minimalist example of creating a thread that periodically
//	wakes up to do something, and also responds promptly when requested to
//	terminate.
//
//	The only work being done is to cycle a counter through four values,
//	which are used to create an ASCII-style spinning character.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class TestThread
{
private:
	volatile S32 m_Counter;

	QzThreadControl m_Thread;

public:
	TestThread(void);
	~TestThread(void);

	void CreateWorkerThread(void);
	void DestroyWorkerThread(void);

	static U32 StaticThreadFunc(void *pContext);

	U32  ThreadFunc(void);

	S32  GetCounter(void) { return m_Counter; }
};


