/////////////////////////////////////////////////////////////////////////////
//
//	File: QzTxtWriter.h
//
//	$Header: /TS/TsFile/QzTxtWriter.h  6  2009/9/7 3:18:32p  Lee $
//
//
//	Handles writing text files.  This can take the internal UTF-8 format and
//	write it to a suitably formatted file.  The default is that the file is
//	also UTF-8, so no extra processing is required.
//
//	This can write ASCII files, but must filter out any symbol that requires
//	more than 8 bits to store.  No attempt is made to map Unicode symbols to
//	ASCII, since most of them don't.  At best, it would have to strip off any
//	accents and print only the base characters.
//
//	It can also write files in UTF-16 and UTF-32 format, but that requires
//	expanding the UTF-8 codes, which generally results in a much larger file.
//
//	The assumption is that everything written is a line of text, so the code
//	will automatically append a CR-LF marker at the end of each write call.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class QzTxtWriter
{
private:
	FILE* m_pFile;
	U32   m_UtfFormat;		// ASCII, UTF-8, UTF-16, etc.
	U32   m_FileSize;		// track how many bytes have been written

public:
	QzTxtWriter(void);
	~QzTxtWriter(void);

	bool CreateNew(const Utf08_t filename[], U32 utfFormat);
	void Close(void);
	void Write(const Utf08_t line[], S32 byteCount = -1);
	void WriteFormat(char pattern[], UtfFormat fmt);
	void WriteLine(Utf08_t line[]);
};


