/////////////////////////////////////////////////////////////////////////////
//
//	File: QzTexture.h
//
//	$Header: /Projects/Qz/QzTexture.h  1  2009/9/9 9:02:21a  Lee $
//
//
//	Container class for holding raw pixel data to be loaded into textures.
//	This is a minimalist implementation, with no support for mip-mapping.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class QzTexture
{
public:
	QzTextureFormat_t	m_Format;
	U32					m_Width;
	U32					m_Height;
	U32					m_BufferSize;
	U08*				m_pBuffer;
	U32					m_hTexture;		// handle for hardware resource: an OpenGL "name"

public:
	QzTexture(void);
	~QzTexture(void);

	bool Allocate(U32 width, U32 height, QzTextureFormat_t format);
};


