/////////////////////////////////////////////////////////////////////////////
//
//	File: QzTexture.h
//
//	$Header: /Projects/Qz/QzTexture.cpp  1  2009/9/9 9:02:27a  Lee $
//
/////////////////////////////////////////////////////////////////////////////


#include "QzCommon.h"
#include "QzTexture.h"


#ifdef USE_MALLOC_MACRO
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
//
//	constructor
//
QzTexture::QzTexture(void)
	:	m_Format(),
		m_Width(0),
		m_Height(0),
		m_BufferSize(0),
		m_pBuffer(NULL),
		m_hTexture(0)
{
}


/////////////////////////////////////////////////////////////////////////////
//
//	destructor
//
QzTexture::~QzTexture(void)
{
	SafeDeleteArray(m_pBuffer);
}


/////////////////////////////////////////////////////////////////////////////
//
//	Allocate()
//
bool QzTexture::Allocate(U32 width, U32 height, QzTextureFormat_t format)
{
	U32 pixelSize = 0;

	switch (format) {
		case QzTexFormat_Alpha:     pixelSize = 1; break;
		case QzTexFormat_Greyscale: pixelSize = 1; break;
		case QzTexFormat_RGB16:     pixelSize = 2; break;
		case QzTexFormat_RGB24:     pixelSize = 3; break;
		case QzTexFormat_ARGB32:    pixelSize = 4; break;
	}

	if (0 == pixelSize) {
		LogErrorMessage("SkTexture:Allocate invalid format");
		return false;
	}

	if ((0 == width) || (width > 2048) || (0 == height) || (height > 2048)) {
		UtfFormat fmt;
		fmt.AddInt(width);
		fmt.AddInt(height);
		LogErrorMessage("QzTexture::Allocate invalid resolution %1;x%2;", fmt);
		return false;
	}

	SafeDeleteArray(m_pBuffer);

	m_Format     = format;
	m_Width      = width;
    m_Height     = height;
	m_BufferSize = width * height * pixelSize;

	m_pBuffer = new U08[m_BufferSize];

	return true;
}





