/////////////////////////////////////////////////////////////////////////////
//
//	File: QzSoundDriver.h
//
//	$Header: /Projects/Qz/QzSoundDriver.h  1  2009/9/9 9:01:39a  Lee $
//
//
//	Common header file for both the Win32 DirectSound and Mac AudioQueue
//	implementations.  This implementation is hardwired to only support
//	stereo 16-bit audio data.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


#define c_AudioBufferCount	3
#define c_AudioChannelCount	2								// stereo
#define c_SlicesPerBuffer	2000
#define c_BytesPerSlice		(2 * c_AudioChannelCount)		// 16-bit samples
#define c_SampleBitDepth	16
#define c_BytesPerBuffer	(c_SlicesPerBuffer * c_BytesPerSlice)


class QzSoundDriver
{
private:
	// Each platform has a custom internal struct that contains the data
	// needed to interface with the sound player.  The struct is stored
	// as a black-box void* pointer so the rest of the app can remain
	// free from any platform-specific header files.
	void* m_pContext;

	U32   m_SampleRate;

public:
	QzSoundDriver(void);
	~QzSoundDriver(void);

	bool Init(U32 sampleRate);
	bool Start(void);
	bool Stop(void);

	U32  MinWriteCount(void);
	U32  FreeBufferCount(void);
	U32  UpdatePosition(U32 lookahead);
	bool WriteToBuffer(S16 *pData, U32 sliceCount);

	// Only implemented for Mac version, since it is needed by the internal
	// callback handler.
	void IncFreeCount(void);
};



