//////////////////////////////////////////////////////////////////////////////
//
//	File: QzQuat.h
//
//	$Header: /TS/TsGui/QzQuat.h  6  2009/9/7 2:15:21p  Lee $
//
//////////////////////////////////////////////////////////////////////////////


#pragma once


#include "QzVector.h"


class QzMatrix3x3;
class QzMatrix4x4;


class QzQuat
{
public:
	float m_X;
	float m_Y;
	float m_Z;
	float m_W;

	float LengthSquared(void) const
	{
		return (m_X * m_X) + (m_Y * m_Y) + (m_Z * m_Z) + (m_W * m_W);
	}

	float Length(void) const
	{
		return sqrtf(LengthSquared());
	}

	void Normalize(void)
	{
		float length = (m_X * m_X) + (m_Y * m_Y) + (m_Z * m_Z) + (m_W * m_W);

		if (length > 0.000001f) {
			float norm = 1.0f / sqrtf(length);
			m_X *= norm;
			m_Y *= norm;
			m_Z *= norm;
			m_W *= norm;
		}
		else {
			m_X = 0.0f;
			m_Y = 0.0f;
			m_Z = 0.0f;
			m_W = 1.0f;
		}
	}

	float DotProduct(const QzQuat &q) const
	{
		return (m_X * q.m_X) + (m_Y * q.m_Y) + (m_Z * q.m_Z) + (m_W * q.m_W);
	}

	void Conjugate(void)
	{
		m_X = -m_X;
		m_Y = -m_Y;
		m_Z = -m_Z;
	}

	void Conjugate(const QzQuat &q)
	{
		m_X = -q.m_X;
		m_Y = -q.m_Y;
		m_Z = -q.m_Z;
		m_W =  q.m_W;
	}

	void Invert(void)
	{
		Normalize();
		Conjugate();
	}

	void MakeIdentity(void)
	{
		m_X = 0.0f;
		m_Y = 0.0f;
		m_Z = 0.0f;
		m_W = 1.0f;
	}

	bool IsIdentity(void)
	{
		return	QzFloatIsZero20(m_X) &&
				QzFloatIsZero20(m_Y) &&
				QzFloatIsZero20(m_Z) &&
				QzEqualFloats20(1.0f, m_W);
	}

	void Multiply(const QzQuat &a, const QzQuat &b);
	void ConvertToMatrix(QzMatrix3x3 &matrix) const;
	void ConvertToMatrix(QzMatrix4x4 &matrix) const;
	void ConvertToAxisAngle(QzVector &axis, float &angle);
	void MakeFromAxisAngle(const QzVector &axis, float angle);
	void MakeFromVectors(QzVector src, QzVector dst);
	void ApplyRotation(const QzVector &rotation);
	void LinearInterpolation(const QzQuat &a, const QzQuat &b, const float interp);
	void SphericalInterpolation(const QzQuat &a, const QzQuat &b, const float interp);
	void Print(void);
};



