/////////////////////////////////////////////////////////////////////////////
//
//	File: QzOggDecoder.h
//
//	$Header: /TS/TsSound/QzOggDecoder.h  6  2009/9/7 3:14:23p  Lee $
//
//
//	Wrapper class around the Ogg Vorbis file reading routines.  This is based
//	around having the compressed data sitting in a buffer in memory.  Ogg's
//	callback interface is used to read data from the buffer.  This allows the
//	audio data to be stored in a custom resource file, and be decompressed
//	from memory.
//
//	NOTE: To build with Xcode, the Ogg.framework and Vorbis.framework must
//	be installed on the system.  These can be found at http://www.xiph.org/
//	as pre-built installs.  These tend to end up in /Library/Frameworks/
//	instead of /System/Library/Frameworks/ so some searching around may be
//	required before you can get them added to the project correctly.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


#ifdef _WIN32
#include "VorbisFile.h"
#else
#define __MACOSX__ // need to explicitly define __MACOSX__ for VorbisTypes.h
#include <Ogg/os_types.h>
#include <Ogg/ogg.h>
#include <Vorbis/vorbisfile.h>
#endif


class QzOggDecoder
{
private:
	OggVorbis_File	m_Context;
	U08*			m_pData;
	U32				m_ByteCount;
	U32				m_Offset;
	U32				m_ChannelCount;
	U32				m_SampleRate;
	U32				m_SliceCount;
	bool			m_IsOpen;

public:
	QzOggDecoder(void);
	~QzOggDecoder(void);

	U32  ChannelCount(void)		{ return m_ChannelCount; }
	U32  SampleRate(void)		{ return m_SampleRate; }
	U32  SliceCount(void)		{ return m_SliceCount; }

	bool Start(U08 *pData, U32 byteCount);
	void Loop(void);
	U32  Read(S16 samples[], U32 sliceCount);
	void Stop(void);

private:
	static size_t CallbackRead(void *pDest, size_t size, size_t sliceCount, void *pContext);
	static int    CallbackSeek(void *pContext, ogg_int64_t offset, int origin);
	static int    CallbackClose(void *pContext);
	static S32    CallbackTell(void *pContext);

	U32 DataTell(void);
	int DataSeek(U32 offset, int whence);
	U32 DataRead(void *ptr, U32 dataSize, U32 dataCount);
	U32 DataClose(void);
};


