/////////////////////////////////////////////////////////////////////////////
//
//	File: QzMatrix4x4.h
//
//	$Header: /TS/TsGui/QzMatrix4x4.h  40  2009/9/7 3:53:09p  Lee $
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


#include "QzQuat.h"


class QzMatrix4x4
{
public:
	QzMatrix4x4_t m_Matrix;

public:
	bool IsEqual(const QzMatrix4x4 &src);
	bool IsIdentity(void);

	void MakeZero(void)				{ SafeZeroVar(m_Matrix); }
	void MakeIdentity(void);
	void MakeWindow(QzRect rect, float nearZ, float farZ);
	void MakeRotateX(float angle);
	void MakeRotateY(float angle);
	void MakeRotateZ(float angle);
	void MakeRotateArbitraryAxis(float x, float y, float z, float angle);
	void MakeRotateArbitraryAxis(const QzVector vec, float angle) { MakeRotateArbitraryAxis(vec.m_X, vec.m_Y, vec.m_Z, angle); }
	void MakeScale(float factor);
	void MakeScale(float x, float y, float z);
	void MakeScale(QzVector vec) { MakeScale(vec.m_X, vec.m_Y, vec.m_Z); }
	void MakeTranslate(float x, float y, float z);
	void MakeTranslate(QzVector vec) { MakeTranslate(vec.m_X, vec.m_Y, vec.m_Z); }

	void MakeLeftHandedPerspectiveFOV(float fov, float aspectRatio, float nearZ, float farZ);
	void MakeRightHandedPerspectiveFOV(float fov, float aspectRatio, float nearZ, float farZ);

	void MakeLeftHandedParallelFOV(float width, float height, float nearZ, float farZ);
	void MakeLeftHandedParallelFOV(const QzRect &rect, float nearZ, float farZ);
	void MakeRightHandedParallelFOV(float width, float height, float nearZ, float farZ);

	void PreRotateX(float angle);
	void PostRotateX(float angle);
	void PreRotateY(float angle);
	void PostRotateY(float angle);
	void PreRotateZ(float angle);
	void PostRotateZ(float angle);
	void PreRotate(QzQuat &quat);
	void PostRotate(QzQuat &quat);
	void PreScale(float x, float y, float z);
	void PreScale(float x);
	void PostScale(float x, float y, float z);
	void PostScale(float x);
	void PreTranslate(float x, float y, float z);
	void PreTranslate(QzVector v) { PreTranslate(v.m_X, v.m_Y, v.m_Z); }
	void PostTranslate(float x, float y, float z);
	void PostTranslate(QzVector v) { PostTranslate(v.m_X, v.m_Y, v.m_Z); }

	void PreTripleRotate(const QzVector rotate);

	void ComputeInverseMatrix(QzMatrix4x4 &src);
	void ComputeNormalMatrix(QzMatrix4x4 &src);

	void Multiply(const QzMatrix4x4 &first, const QzMatrix4x4 &second);
	void PreMultiply(const QzMatrix4x4 &first);
	void PostMultiply(const QzMatrix4x4 &second);
	void TransformVector(const QzVector vec, QzVector &result);
	void TransformVector(const QzVector_t vec, QzVector_t &result);
	void TransformVectorW(const QzVector vec, QzVector &result, float &w);
	void TransformNormal(const QzVector vec, QzVector &result);
	void Transpose(void);
	void LeftHandedToRightHanded(const QzMatrix4x4 &src);

	void LogMatrix(void);
	void PrintMatrix(void);
};

