/////////////////////////////////////////////////////////////////////////////
//
//	File: QzManager.h
//
//	$Header: /Projects/Qz/QzManager.h  3  2009/9/14 5:44:08p  Lee $
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


#include "QzInterface.h"


class QzClient;
class QzKeyMapper;
class QzRenderer;


class QzManager
	:	public QzInterface
{
private:
	QzClient*		m_pClient;
	QzKeyMapper*	m_pKeyMapper;
	QzRenderer*		m_pRenderer;

	U32				m_FrameCount;
	U32				m_FrameCountLatch;
	U32				m_FrameCountTick;
	U32				m_TimestampPrevious;	// timestamp when stated rendering previous frame
	U32				m_TimestampCurrent;		// timestamp at beginning of current frame
	float			m_CpuUsage;

	bool			m_ShowFPS;

	volatile bool	m_IsWindowDirty;
	bool			m_IsWindowActive;
	bool			m_IsMouseExclusive;		// do we want the mouse to be locked?

public:
	QzManager(void);
	~QzManager(void);

	virtual U32  GetFrameDuration(void);
	virtual U32  GetKeyState(U32 key);
	virtual bool IsMouseExclusive(void);
	virtual void RequestAppTermination(void);
	virtual void SetMouseExclusive(bool exclusive);
	virtual void ClearDirtyFlag(void);
	virtual void SetDirtyFlag(void);

	bool Initialize(void);
	bool CreateRenderer(void);
	bool DestroyRenderer(void);

	void DeviceInputClear(void);
	void DeviceInputBegin(void);
	void DeviceInputEnd(void);

	bool IsWindowDirty(void);

	void GetAppTitle(Utf08_t buffer[], U32 bufferSize);
	U32  GetMaxFrameDelay(void);
	void SetResolution(U32 width, U32 height);
	void KeyPress(U32 keyFlags, U32 key, bool isDown, bool isSystem);
	void KeyChar(Utf32_t keyChar);
	void MouseMove(S32 x, S32 y);
	void MouseDelta(S32 dx, S32 dy);
	void MouseClick(QzMouseButton_t button, QzMouseClick_t click, U32 flags, S32 x, S32 y);
	void MouseWheel(S32 delta);
	void WindowActivated(bool activated);
	bool Render(void);
};



