/////////////////////////////////////////////////////////////////////////////
//
//	File: QzMainWin.h
//
//	$Header: /Projects/Qz/qzmainwin.h  1  2009/9/7 4:09:19p  Lee $
//
//
//	This class is only used when building on Windows.  It implements the
//	front end for dealing with mouse and keyboard input, and managing the
//	window in which we will be rendering.
//
//	All events from this class are converted to a platform-independent format
//	and passed to QzManager, which allows QzManager to remain completely
//	ignorant of the platform upon which it is running.
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


class QzManager;
class QzRenderer;


class QzMainWin
{
public:
	QzManager*	m_pManager;

	RECT  m_WindowRect;
	HGLRC m_hOpenglRC;
	bool  m_WindowActive;		// set to false when window is minimized/hidden
	bool  m_WindowMinimized;
	long  m_WindowWidth;
	long  m_WindowHeight;
	bool  m_LeftDown;
	bool  m_RightDown;
	bool  m_HasCapture;
	U32   m_FrameCount;
	bool  m_FullScreen;


	/////////////////////////////////////////////////////////////////////////

	QzMainWin(void);
	~QzMainWin(void);

	bool InitPixelFormat(HDC hDC);
	void ResizeWindow(long width, long height);
	void HandleResized(HWND hWindow);
	void UpdateMouseCapture(void);
	void HandleHighDefInput(LPARAM lParam);
	ATOM RegisterWindowClass(HINSTANCE hInstance);
	HWND InitInstance(HINSTANCE hInstance, int showCommand, Utf08_t appTitle[]);
	void EnableVSync(BOOL enabled);

	LRESULT MessageHandler(HWND hWindow, UINT message, WPARAM wParam, LPARAM lParam);

	bool Init(HINSTANCE hInstance, int showCommand);
	int  Run(void);
};


