/////////////////////////////////////////////////////////////////////////////
//
//	File: QzDirList.h
//
//	$Header: /Projects/Qz/QzDirList.h  4  2009/9/7 1:11:40p  Lee $
//
//
//	This is a wrapper class around the native file iteration logic.  It will
//	scan a given directory, extracting all folders and files (optionally
//	filtering only files that have a specific extension).
//
//	The resulting list will be sorted alphabetically (case in-sensitive).
//	By default, the sorting will list all folder names first, followed by
//	the file names.  Clear the m_SortDirsFirst flag to force file and folder
//	names to be intermixed.
//
//	Make certain the desired m_Show... flags are set before making the first
//	call to ScanDirectory().  The m_Show... flags all default to false, so
//	forgetting to set them will result in an empty list.
//
//	After the initial call to ScanDirectory(), simple navigation to other
//	folders can be accomplished by calling UpOneLevel() and DownOneLevel().
//
/////////////////////////////////////////////////////////////////////////////


#pragma once


struct QzDirEntry_t
{
	bool     IsDir;
	Utf08_t* pName;
	U32      Size;
	U32      Time;
};


class QzDirList
{
public:
	bool			m_ShowDirs;			// include sub-folders in the list
	bool			m_ShowFiles;		// include files
	bool			m_ShowHidden;
	bool			m_ShowReadOnly;
	bool			m_ShowSystem;
	bool			m_SortDirsFirst;	// keep all folders at start of list
	U32				m_EntryCount;
	U32				m_MaxEntryCount;
	QzDirEntry_t*	m_pList;
	Utf08_t			m_Path[c_MaxPathLength];
	Utf08_t			m_Extension[32];

public:
	QzDirList(void);
	~QzDirList(void);

	bool ScanDirectory(const Utf08_t path[], const Utf08_t *pExtension = NULL);
	bool UpOneLevel(void);
	bool DownOneLevel(const Utf08_t dirName[]);

private:
	void Free(void);
	void Grow(void);
	bool ScanPath(void);
	void SortRange(S32 lo, S32 hi);
};

